/* SPDX-License-Identifier: GPL-2.0
 ****************************************************************************
 * Driver for Xilinx network controllers and boards
 * Copyright 2021 Xilinx Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 */
#ifdef CONFIG_XILINX_DEBUGFS

#ifndef EFCT_DEBUGFS_H
#define EFCT_DEBUGFS_H

struct seq_file;

struct efct_debugfs_parameter {
	const char *name;
	size_t offset;
	int (*reader)(struct seq_file *file, void *data);
};

/* Helpers for handling debugfs entry reads */
int efct_debugfs_read_int(struct seq_file *file, void *data);
int efct_debugfs_read_s8(struct seq_file *file, void *data);
int efct_debugfs_read_uint(struct seq_file *file, void *data);
int efct_debugfs_read_u32(struct seq_file *file, void *data);
int efct_debugfs_read_u64(struct seq_file *file, void *data);
int efct_debugfs_read_u8(struct seq_file *file, void *data);
int efct_debugfs_read_addr(struct seq_file *file, void *data);
int efct_debugfs_read_u16(struct seq_file *file, void *data);
int efct_debugfs_read_uchar(struct seq_file *file, void *data);
int efct_debugfs_read_atomic(struct seq_file *file, void *data);
int efct_debugfs_read_bool(struct seq_file *file, void *data);
int efct_debugfs_read_ulong(struct seq_file *file, void *data);
int efct_debugfs_read_string(struct seq_file *file, void *data);

/* Initialiser for a struct efct_debugfs_parameter without type-checking */
#define _EFCT_PARAMETER(container_type, parameter, reader_function) {	\
	.name = #parameter,						\
	.offset = offsetof(container_type, parameter),			\
	.reader = reader_function,					\
}

/* Initialiser for a struct efct_debugfs_parameter with type-checking */
#define EFCT_PARAMETER(container_type, parameter, field_type,		\
			reader_function) {				\
	.name = #parameter,						\
	.offset = ((((field_type *)0) ==				\
		    &((container_type *)0)->parameter) ?		\
		   offsetof(container_type, parameter) :		\
		   offsetof(container_type, parameter)),		\
	.reader = reader_function,					\
}

/* An integer parameter */
#define EFCT_INT_PARAMETER(container_type, parameter)		\
	EFCT_PARAMETER(container_type, parameter,		\
		      int, efct_debugfs_read_int)

/* An unsigned integer parameter */
#define EFCT_UINT_PARAMETER(container_type, parameter)		\
	EFCT_PARAMETER(container_type, parameter,		\
		      u32, efct_debugfs_read_uint)

/* A u32 parameter */
#define EFCT_U32_PARAMETER(container_type, parameter)		\
	EFCT_PARAMETER(container_type, parameter,		\
		      u32, efct_debugfs_read_u32)

/* A u8 parameter */
#define EFCT_U8_PARAMETER(container_type, parameter)		\
	EFCT_PARAMETER(container_type, parameter,		\
		      u8, efct_debugfs_read_u8)

/* A u16 parameter */
#define EFCT_U16_PARAMETER(container_type, parameter)		\
	EFCT_PARAMETER(container_type, parameter,		\
		      u16, efct_debugfs_read_u16)

/* A unsigned char parameter */
#define EFCT_UCHAR_PARAMETER(container_type, parameter)		\
	EFCT_PARAMETER(container_type, parameter,		\
		      unsigned char, efct_debugfs_read_uchar)

/* An atomic_t parameter */
#define EFCT_ATOMIC_PARAMETER(container_type, parameter)		\
	EFCT_PARAMETER(container_type, parameter,		\
		      atomic_t, efct_debugfs_read_atomic)

#define EFCT_BOOL_PARAMETER(container_type, parameter)		\
	EFCT_PARAMETER(container_type, parameter,		\
		      bool, efct_debugfs_read_bool)

#define EFCT_ULONG_PARAMETER(container_type, parameter)		\
	EFCT_PARAMETER(container_type, parameter,		\
		      unsigned long, efct_debugfs_read_ulong)

#define EFCT_U64_PARAMETER(container_type, parameter)		\
	EFCT_PARAMETER(container_type, parameter,		\
		      u64, efct_debugfs_read_u64)

#define EFCT_S8_PARAMETER(container_type, parameter)		\
	EFCT_PARAMETER(container_type, parameter,		\
		      s8, efct_debugfs_read_s8)

/* A string parameter (string embedded in the structure) */
#define EFCT_ADDR_PARAMETER(container_type, parameter) {	\
	.name = #parameter,					\
	.offset = ((((void *)0) ==				\
		    ((container_type *)0)->parameter) ?	\
		   offsetof(container_type, parameter) :	\
		   offsetof(container_type, parameter)),	\
	.reader = efct_debugfs_read_addr,			\
}

/* A string parameter (string embedded in the structure) */
#define EFCT_STRING_PARAMETER(container_type, parameter) {	\
	.name = #parameter,					\
	.offset = ((((char *)0) ==				\
		    ((container_type *)0)->parameter) ?	\
		   offsetof(container_type, parameter) :	\
		   offsetof(container_type, parameter)),	\
	.reader = efct_debugfs_read_string,			\
}

int efct_init_debugfs(const char *module);
int efct_init_debugfs_nic(struct efct_nic *efct);
int efct_init_debugfs_func(struct efct_device *efct_dev);
void efct_fini_debugfs_func(struct efct_device *efct_dev);
void efct_fini_debugfs_child(struct dentry *dir, const char *name);
void efct_fini_debugfs_nic(struct efct_nic *efct);
void efct_fini_debugfs_rx_queue(struct efct_rx_queue *rx_queue);
int efct_init_debugfs_rx_queue(struct efct_rx_queue *rx_queue);
void efct_fini_debugfs_tx_queue(struct efct_tx_queue *tx_queue);
int efct_init_debugfs_tx_queue(struct efct_tx_queue *tx_queue);
void efct_fini_debugfs_ev_queue(struct efct_ev_queue *ev_queue);
int efct_init_debugfs_ev_queue(struct efct_ev_queue *ev_queue);
#ifdef CONFIG_XILINX_AUX_EFCT
int efct_init_debugfs_aux_dev_client(struct xlnx_efct_client *client);
int efct_init_debugfs_aux_dev(struct efct_nic *efct);
void efct_fini_debugfs_aux_dev_client(struct xlnx_efct_client *client);
void efct_fini_debugfs_aux_dev(struct efct_nic *efct);
#endif
void efct_fini_debugfs(void);

#endif /* EFCT_DEBUGFS_H */
#endif /* CONFIG_XILINX_DEBUGFS */
