/* SPDX-License-Identifier: GPL-2.0
 ***************************************************************************
 * Driver for Xilinx network controllers and boards
 * Copyright 2021 Xilinx Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 */
#ifdef CONFIG_XILINX_AUX_EFCT

#ifndef EFCT_AUXBUS_H
#define EFCT_AUXBUS_H

int efct_auxbus_register(struct efct_nic *efct);
void efct_auxbus_unregister(struct efct_nic *efct);
int efct_aux_buffer_start(struct efct_nic *efct, int rxq_id, u32 sbseq,
			  int sbid, bool sentinel);
int efct_aux_buffer_end(struct efct_nic *efct, int rxq_id, int sbid, bool force);
int efct_aux_poll(struct efct_nic *efct, int rxq_id, int budget);
int efct_aux_handle_event(struct efct_nic *efct, enum xlnx_event_type event,
			  int rxq, u64 value, int budget);
bool efct_aux_packet_handled(struct efct_nic *efct, int rxq_id, bool flow_lookup,
			     void *meta, void *payload);
void efct_aux_on_dev_reset(struct efct_nic *efct);

#endif
#endif //EFCT_AUXBUS_H
