/* SPDX-License-Identifier: GPL-2.0
 ****************************************************************************
 * Driver for Xilinx network controllers and boards
 * Copyright 2021 Xilinx Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 */

#ifndef EFCT_COMMON_H
#define EFCT_COMMON_H

struct efct_func_ctl_window {
	bool valid;
	u32 bar;
	u64 offset;
};

struct queue_reset_work {
	struct work_struct work;
	struct efct_nic *efct;
	bool is_txq;
	int qid;
};

int efct_init_io(struct efct_device *efct_dev,
		 int bar, dma_addr_t dma_mask, u32 mem_map_size);
void efct_fini_io(struct efct_device *efct_dev);
int efct_init_struct(struct efct_nic *efct);
void efct_fini_struct(struct efct_nic *efct);
int efct_map_membase(struct efct_nic *efct, struct efct_func_ctl_window *fcw, u8 port_id);
void efct_unmap_membase(struct efct_nic *efct);
#ifdef CONFIG_XILINX_AUX_EFCT
void efct_make_irq_resources(struct efct_nic *efct, struct msix_entry *xentries, u8 index);
#endif
int efct_probe_common(struct efct_nic *efct);
void efct_remove_common(struct efct_nic *efct);
void efct_schedule_reset(struct efct_nic *efct, enum reset_type type);
int efct_create_reset_workqueue(void);
void efct_destroy_reset_workqueue(void);
void efct_flush_reset_workqueue(void);
void efct_reset_sw_stats(struct efct_nic *efct);
void efct_set_evq_names(struct efct_nic *efct);
void efct_link_status_changed(struct efct_nic *efct);
int efct_mac_reconfigure(struct efct_nic *efct);
int efct_set_mac_address(struct net_device *net_dev, void *data);
int __efct_reconfigure_port(struct efct_nic *efct);
int efct_reset(struct efct_nic *efct, enum reset_type method);
void efct_schedule_queue_reset(struct efct_nic *efct, bool is_txq, int qid);
int efct_change_mtu(struct net_device *net_dev, int new_mtu);
int efct_fill_spec(struct efct_nic *efct, const struct ethtool_rx_flow_spec *rule,
		   struct efct_filter_spec *spec);
int efct_delete_rule(struct efct_nic *efct, u32 id);
int efct_init_stats_task(struct efct_device *efct_dev);
void efct_fini_stats_task(struct efct_device *efct_dev);
#if !defined(EFCT_USE_KCOMPAT) || defined(EFCT_HAVE_NDO_GET_PHYS_PORT_ID)
int efct_get_phys_port_id(struct net_device *net_dev, struct netdev_phys_item_id *ppid);
#endif
#if !defined(EFCT_USE_KCOMPAT) || defined(EFCT_HAVE_NDO_GET_PHYS_PORT_NAME)
int efct_get_phys_port_name(struct net_device *net_dev, char *name, size_t len);
#endif
int efct_filter_table_down(struct efct_nic *efct);
int efct_filter_table_up(struct efct_nic *efct);
static inline bool efct_filter_spec_equal(const struct efct_filter_spec *left,
					  const struct efct_filter_spec *right)
{
	return memcmp(&left->dst_ip, &right->dst_ip,
		      sizeof(struct efct_filter_spec) -
		      offsetof(struct efct_filter_spec, dst_ip)) == 0;
}

static inline int efct_check_disabled(struct efct_nic *efct)
{
	if (efct->state == STATE_DISABLED) {
		netif_err(efct, drv, efct->net_dev,
			  "device is disabled due to earlier errors\n");
		return -EIO;
	}
	return 0;
}

#define EFCT_ASSERT_RESET_SERIALISED(efct) \
	do { \
		if ((efct)->state != STATE_UNINIT && (efct)->state != STATE_PROBED) \
			ASSERT_RTNL(); \
	} while (0)

#endif

