/* SPDX-License-Identifier: GPL-2.0
 ****************************************************************************
 * Driver for Xilinx network controllers and boards
 * Copyright 2021 Xilinx Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 */

#ifndef EFCT_NETDEV_H
#define EFCT_NETDEV_H

#include <linux/netdevice.h>
#include "efct_nic.h"

int efct_probe_netdev(struct efct_nic *efct);
int efct_remove_netdev(struct efct_nic *efct);
int efct_close_netdev(struct efct_nic *efct);
int efct_register_netdev(struct efct_nic *efct);
void efct_unregister_netdev(struct efct_nic *efct);
int efct_get_mac_address(struct efct_nic *efct, u8 *mac_address);
#endif
