/* SPDX-License-Identifier: GPL-2.0
 ****************************************************************************
 * Driver for Xilinx network controllers and boards
 * Copyright 2021 Xilinx Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 */

#ifndef EFCT_REGS_H
#define EFCT_REGS_H

#include "efct_reg.h"

/* XIL_CFGBAR_TBL_ENTRY */
#define	ESF_GZ_CFGBAR_CONT_CAP_OFF_HI_LBN 96
#define	ESF_GZ_CFGBAR_CONT_CAP_OFF_HI_WIDTH 32
#define	ESF_GZ_CFGBAR_CONT_CAP_OFFSET_LBN 68
#define	ESF_GZ_CFGBAR_CONT_CAP_OFFSET_WIDTH 60
#define	ESE_GZ_CONT_CAP_OFFSET_BYTES_SHIFT 4
#define	ESF_GZ_CFGBAR_CONT_CAP_OFF_LO_LBN 68
#define	ESF_GZ_CFGBAR_CONT_CAP_OFF_LO_WIDTH 28
#define	ESF_GZ_CFGBAR_CONT_CAP_RSV_LBN 67
#define	ESF_GZ_CFGBAR_CONT_CAP_RSV_WIDTH 1
#define	ESE_GZ_CFGBAR_EFCT_BAR_NUM_INVALID 7
#define	ESE_GZ_CFGBAR_EFCT_BAR_NUM_EXPANSION_ROM 6
#define	ESF_GZ_CFGBAR_CONT_CAP_BAR_LBN 64
#define	ESF_GZ_CFGBAR_CONT_CAP_BAR_WIDTH 3
#define	ESE_GZ_CFGBAR_CONT_CAP_BAR_NUM_INVALID 7
#define	ESE_GZ_CFGBAR_CONT_CAP_BAR_NUM_EXPANSION_ROM 6
#define	ESE_GZ_CFGBAR_ENTRY_SIZE_EFCT 24
#define	ESE_GZ_CFGBAR_ENTRY_HEADER_SIZE 8
#define	ESE_GZ_CFGBAR_ENTRY_REV_EFCT 0
#define	ESE_GZ_CFGBAR_ENTRY_LAST 0xfffff
#define	ESE_GZ_CFGBAR_ENTRY_CONT_CAP_ADDR 0xffffe
#define	ESE_GZ_CFGBAR_ENTRY_EFCT 0x1
#define	ESE_GZ_XIL_CFGBAR_TBL_ENTRY_STRUCT_SIZE 128

#define EFCT_VSEC_TABLE_ENTRY_OFFSET 0x10

#define EFCT_VSEC_ENTRY_PROJECT_ID_VAL 0x5833
#define EFCT_VSEC_ENTRY_TYPE_REV_VAL 0
#define EFCT_VSEC_ENTRY_TABLE_TYPE_VAL 0x20

/* XIL_CFGBAR_VSEC */
#define	ESF_GZ_VSEC_TBL_OFF_HI_LBN 64
#define	ESF_GZ_VSEC_TBL_OFF_HI_WIDTH 32
#define	ESE_GZ_VSEC_TBL_OFF_HI_BYTES_SHIFT 32
#define	ESF_GZ_VSEC_TBL_OFF_LO_LBN 36
#define	ESF_GZ_VSEC_TBL_OFF_LO_WIDTH 28
#define	ESE_GZ_VSEC_TBL_OFF_LO_BYTES_SHIFT 4
#define	ESF_GZ_VSEC_TBL_BAR_LBN 32
#define	ESF_GZ_VSEC_TBL_BAR_WIDTH 4
#define	ESE_GZ_VSEC_BAR_NUM_INVALID 7
#define	ESE_GZ_VSEC_BAR_NUM_EXPANSION_ROM 6
#define	ESE_GZ_VSEC_LEN_HIGH_OFFT 16
#define	ESE_GZ_VSEC_LEN_MIN 12
#define	ESE_GZ_VSEC_VER_XIL_CFGBAR 0
#define	ESE_GZ_XLNX_VSEC_ID 0x20
#define	ESE_GZ_XIL_CFGBAR_VSEC_STRUCT_SIZE 96

/* Enum DESIGN_PARAMS */
#define	ESE_EFCT_DP_GZ_EV_QUEUES 18
#define	ESE_EFCT_DP_GZ_EVQ_SIZES 17
#define	ESE_EFCT_DP_GZ_RX_MAX_RUNT 16
#define	ESE_EFCT_DP_GZ_RX_L4_CSUM_PROTOCOLS 15
#define	ESE_EFCT_DP_GZ_EVQ_UNSOL_CREDIT_SEQ_BITS 14
#define	ESE_EFCT_DP_GZ_PARTIAL_TSTAMP_SUB_NANO_BITS 13
#define	ESE_EFCT_DP_GZ_TX_PACKET_FIFO_SIZE 12
#define	ESE_EFCT_DP_GZ_TX_CTPIO_APERTURE_SIZE 11
#define	ESE_EFCT_DP_GZ_TX_MAXIMUM_REORDER 10
#define	ESE_EFCT_DP_GZ_RX_METADATA_LENGTH 9
#define	ESE_EFCT_DP_GZ_FRAME_OFFSET_FIXED 8
#define	ESE_EFCT_DP_GZ_RX_BUFFER_FIFO_SIZE 7
#define	ESE_EFCT_DP_GZ_TX_CTPIO_APERTURES 6
#define	ESE_EFCT_DP_GZ_RX_QUEUES 5
#define	ESE_EFCT_DP_GZ_RX_BUFFER_SIZE 4
#define	ESE_EFCT_DP_GZ_CTPIO_STRIDE 3
#define	ESE_EFCT_DP_GZ_EVQ_STRIDE 2
#define	ESE_EFCT_DP_GZ_RX_STRIDE 1
#define	ESE_EFCT_DP_GZ_PAD 0

#define	ESF_GZ_TX_SEND_ADDR_WIDTH 64

/* Enum XN_EVENT_TYPE */
//X2 has these macros in efct_reg.h. Is H/W supposed to update header file?
#define	ESE_HZ_XN_EVENT_TYPE_DRIVER 0x5
#define	ESF_HZ_DRIVER_DATA_LBN 0
#define	ESF_HZ_DRIVER_DATA_WIDTH 59

#endif
