/* SPDX-License-Identifier: GPL-2.0
 ****************************************************************************
 * Driver for Xilinx network controllers and boards
 * Copyright 2021 Xilinx Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 */

#ifndef EFCT_EFCT_RX_H
#define EFCT_EFCT_RX_H

#include "net_driver.h"
/*Count to wait for in case of sentinel mismatch*/
#define SENTINEL_MISMATCH_COUNT 2000

int dbl_init(struct efct_rx_queue *rxq);
void dbl_fini(struct efct_rx_queue *rxq);
int nbl_init(struct efct_rx_queue *rxq);
void nbl_reset(struct efct_rx_queue *rxq);
#ifdef CONFIG_XILINX_AUX_EFCT
int hpl_init(struct efct_rx_queue *rxq);
int sbl_init(struct efct_rx_queue *rxq);
void sbl_release_buff(struct efct_rx_queue *rxq, int id);
int hpl_add_hp_for_client(struct efct_rx_queue *rxq,
			  struct xlnx_efct_client *client_id, int hp_count);
int hpl_remove_hp_for_client(struct efct_rx_queue *rxq, struct xlnx_efct_client *client_id,
			     int n_hp);
int efct_rx_rollover(struct efct_rx_queue *rxq);
int hpl_get_hugepages(struct efct_rx_queue *rxq, struct xlnx_efct_hugepage *pages, size_t n_pages);
#endif
int efct_fill_rx_buffs(struct efct_rx_queue *rxq);
void efct_ev_rx(struct efct_rx_queue *rxq, const efct_qword_t *p_event);

#endif
