/* SPDX-License-Identifier: GPL-2.0
 ****************************************************************************
 * Driver for Xilinx network controllers and boards
 * Copyright 2021 Xilinx Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 */

#ifndef EFCT_FILTER_H
#define EFCT_FILTER_H

#include <linux/types.h>
#include <linux/if_ether.h>
#include <asm/byteorder.h>

#define IP4_ADDR_MASK	((__force __be32)~0)
#define PORT_MASK		((__force __be16)~0)
#define MULTICAST_DST_MASK htonl(0xf0000000)
#define MULTICAST_ADDR_START htonl(0xe0000000)

//TODO check for exact HW depth.Also hope this is for per function and not per port,check on this.
#define EFCT_MCDI_FILTER_TBL_ROWS 256
#define EFCT_HANDLE_INVALID 0xFFFFFFFFFFFFFFFF

struct efct_filter_spec {
	u32 match_fields;
	u64 queue_id;
	__be16	ether_type;
	__be32 dst_ip;
	__be16	dst_port;
	u8	ip_proto;
};

struct efct_mcdi_filter_table {
	struct rw_semaphore lock; /* Protects entries */
	struct {
		unsigned long spec;     /* pointer to spec */
		u64 handle;	     /* firmware handle */
		u64 ref_cnt; /*ref count for clients*/
	} *entry;
};

#endif /* EFCT_FILTER_H */
