// SPDX-License-Identifier: GPL-2.0
/****************************************************************************
* Driver for Xilinx network controllers and boards
* Copyright 2021 Xilinx Inc.
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License version 2 as published
* by the Free Software Foundation, incorporated herein by reference.
*/

#define EFCT_IN_KCOMPAT_C 1

#include "kernel_compat.h"

#ifdef EFCT_USE_DEVLINK

#ifdef EFCT_NEED_DEVLINK_FLASH_UPDATE_TIMEOUT_NOTIFY
void devlink_flash_update_timeout_notify(struct devlink *devlink,
					 const char *status_msg,
					 const char *component,
					 unsigned long timeout)
{
	/* Treat as a status notifcation with no timeout indicated */
	devlink_flash_update_status_notify(devlink, status_msg, component, 0, 0);
}
#endif

#else

static int efct_devlink_info_add(struct devlink_info_req *req,
				 const char *prefix, const char *name,
				const char *value)
{
	int offset = strlen(req->buf);

	scnprintf(&req->buf[offset], req->bufsize - offset, "%s%s: %s\n",
		  prefix, name, value);
	return 0;
}

int devlink_info_serial_number_put(struct devlink_info_req *req, const char *sn)
{
	return efct_devlink_info_add(req, "", "serial_number", sn);
}

int devlink_info_driver_name_put(struct devlink_info_req *req, const char *name)
{
	return efct_devlink_info_add(req, "", "driver", name);
}

int devlink_info_board_serial_number_put(struct devlink_info_req *req,
					 const char *bsn)
{
	return efct_devlink_info_add(req, "board.", "serial_number", bsn);
}

int devlink_info_version_fixed_put(struct devlink_info_req *req,
				   const char *version_name,
				   const char *version_value)
{
	return efct_devlink_info_add(req, "fixed.", version_name, version_value);
}

int devlink_info_version_stored_put(struct devlink_info_req *req,
				    const char *version_name,
				    const char *version_value)
{
	return efct_devlink_info_add(req, "stored.", version_name,
				    version_value);
}

int devlink_info_version_running_put(struct devlink_info_req *req,
				     const char *version_name,
				     const char *version_value)
{
	return efct_devlink_info_add(req, "running.", version_name,
				    version_value);
}

#endif	/* !EFCT_USE_DEVLINK */
/* Kernel backwards compatibility
 * This file provides functionality missing from earlier kernels.
 */
