/* SPDX-License-Identifier: GPL-2.0
 ****************************************************************************
 * Driver for Xilinx network controllers and boards
 * Copyright 2021 Xilinx Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 */

#ifndef EFCT_MCDI_FUNCTIONS_H
#define EFCT_MCDI_FUNCTIONS_H

#include "filter.h"
int efct_mcdi_ev_init(struct efct_ev_queue *eventq);
int efct_mcdi_rx_init(struct efct_rx_queue *rx_queue);
int efct_mcdi_tx_init(struct efct_tx_queue *tx_queue);
int efct_mcdi_ev_fini(struct efct_ev_queue *eventq);
int efct_mcdi_ev_set_timer(struct efct_ev_queue *eventq, u32 ns, u32 mode, bool async);
int efct_mcdi_rx_fini(struct efct_rx_queue *rx_queue);
int efct_mcdi_tx_fini(struct efct_tx_queue *tx_queue);
int efct_mcdi_filter_insert(struct efct_nic *efct, struct efct_filter_spec *rule, u64 *handle);
int efct_mcdi_filter_remove(struct efct_nic *efct, u64 handle);
int efct_mcdi_filter_table_probe(struct efct_nic *efct);
void efct_mcdi_filter_table_remove(struct efct_nic *efct);
#endif
