/* SPDX-License-Identifier: GPL-2.0
 ****************************************************************************
 * Driver for Xilinx network controllers and boards
 * Copyright 2021 Xilinx Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 */
 #ifndef EFCT_MCDI_PORT_COMMON_H
#define EFCT_MCDI_PORT_COMMON_H

enum efct_stats_action {
	EFCT_STATS_ENABLE,
	EFCT_STATS_DISABLE,
	EFCT_STATS_PULL,
	EFCT_STATS_PERIOD,
	EFCT_STATS_NODMA,
};

#define MCDI_PORT_SPEED_CAPS   ((1 << MC_CMD_PHY_CAP_10HDX_LBN) | \
				(1 << MC_CMD_PHY_CAP_10FDX_LBN) | \
				(1 << MC_CMD_PHY_CAP_100HDX_LBN) | \
				(1 << MC_CMD_PHY_CAP_100FDX_LBN) | \
				(1 << MC_CMD_PHY_CAP_1000HDX_LBN) | \
				(1 << MC_CMD_PHY_CAP_1000FDX_LBN) | \
				(1 << MC_CMD_PHY_CAP_10000FDX_LBN) | \
				(1 << MC_CMD_PHY_CAP_40000FDX_LBN) | \
				(1 << MC_CMD_PHY_CAP_100000FDX_LBN) | \
				(1 << MC_CMD_PHY_CAP_25000FDX_LBN) | \
				(1 << MC_CMD_PHY_CAP_50000FDX_LBN))

#define SET_LINK_SEQ_IGNORE BIT(MC_CMD_SET_LINK_IN_V2_MODULE_SEQ_IGNORE_LBN)

#define SFF8024_ID_SFP		0x03
#define SFF8024_ID_DSFP		0x1B
#define SFF_DIAG_TYPE_OFFSET	92
#define SFF_DIAG_ADDR_CHANGE	BIT(2)
#define SFF_DIAG_IMPLEMENTED	BIT(6)
#define SFF_8079_NUM_PAGES	2
#define SFF_8472_NUM_PAGES	4
#define SFF_8436_NUM_PAGES	5
#define SFF_DMT_LEVEL_OFFSET	94

struct efct_mcdi_phy_data {
	u32 flags;
	u32 type;
	u32 supported_cap;
	u32 channel;
	u32 port;
	u32 stats_mask;
	u8 name[20];
	u32 media;
	u32 mmd_mask;
	u8 revision[20];
};

int efct_mcdi_port_get_number(struct efct_nic *efct);
int efct_mcdi_mac_init_stats(struct efct_nic *efct);
void efct_mcdi_mac_fini_stats(struct efct_nic *efct);
int efct_mcdi_mac_stats(struct efct_nic *efct,
			enum efct_stats_action action, int clear,
			void *outbuf, size_t buflen);
int efct_mcdi_set_mac(struct efct_nic *efct);
int efct_mcdi_get_phy_cfg(struct efct_nic *efct, struct efct_mcdi_phy_data *cfg);
void mcdi_to_ethtool_linkset(struct efct_nic *efct, u32 media, u32 cap,
			     unsigned long *linkset);
u32 efct_get_mcdi_phy_flags(struct efct_nic *efct);

int efct_mcdi_set_link(struct efct_nic *efct, u32 capabilities,
		       u32 flags, u32 loopback_mode, u8 seq);
void efct_link_set_advertising(struct efct_nic *efct, const unsigned long *advertising);
void efct_link_set_wanted_fc(struct efct_nic *efct, u8 wanted_fc);
u32 ethtool_linkset_to_mcdi_cap(const unsigned long *linkset);
#if !defined(EFCT_USE_KCOMPAT) || defined(EFCT_HAVE_ETHTOOL_LINKSETTINGS)
int efct_mcdi_phy_set_ksettings(struct efct_nic *efct,
				const struct ethtool_link_ksettings *settings,
				unsigned long *advertising);
void efct_mcdi_phy_get_ksettings(struct efct_nic *efct,
				 struct ethtool_link_ksettings *out);
#endif
void efct_mcdi_phy_decode_link(struct efct_nic *efct,
			       struct efct_link_state *link_state,
			       u32 speed, u32 flags, u32 fcntl,
			       u32 ld_caps, u32 lp_caps);
bool efct_mcdi_port_process_event_common(struct efct_ev_queue *evq, efct_qword_t *event);
void efct_mcdi_process_link_change_v2(struct efct_nic *efct, efct_qword_t *ev);
bool efct_mcdi_phy_poll(struct efct_nic *efct);
int efct_mcdi_set_mac(struct efct_nic *efct);
int efct_mcdi_loopback_modes(struct efct_nic *efct, u64 *loopback_modes);
int efct_mcdi_phy_get_fecparam(struct efct_nic *efct, struct ethtool_fecparam *fec);
u32 efct_get_mcdi_caps(struct efct_nic *efct);
void efct_mcdi_process_module_change(struct efct_nic *efct, efct_qword_t *ev);
int efct_mcdi_set_id_led(struct efct_nic *efct, enum efct_led_mode mode);
int efct_mcdi_phy_get_module_info_locked(struct efct_nic *efct,
					 struct ethtool_modinfo *modinfo);
int efct_mcdi_phy_get_module_eeprom_locked(struct efct_nic *efct,
					   struct ethtool_eeprom *ee, u8 *data);
#if !defined(EFCT_USE_KCOMPAT) || defined(EFCT_HAVE_EEPROM_BY_PAGE)
int efct_mcdi_get_eeprom_page_locked(struct efct_nic *efct,
				     const struct ethtool_module_eeprom *page_data,
				     struct netlink_ext_ack *extack);
#endif
int efct_mcdi_phy_test_alive(struct efct_nic *efct);
#endif
