// SPDX-License-Identifier: GPL-2.0
/****************************************************************************
 * Driver for Xilinx network controllers and boards
 * Copyright 2021 Xilinx Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 */

#undef TRACE_SYSTEM
#define TRACE_SYSTEM xilinx_efct

#if !defined(TRACE_EVENTS_XILINX_EFCT_H) || defined(TRACE_HEADER_MULTI_READ)
#define TRACE_EVENTS_XILINX_EFCT_H

#include <linux/tracepoint.h>

TRACE_EVENT(xilinx_efct_receive,

	TP_PROTO(const struct sk_buff *skb, u8 *pkt_start, efct_qword_t *p_meta, struct efct_rx_queue *rxq),

	TP_ARGS(skb, pkt_start, p_meta, rxq),

	TP_STRUCT__entry(
		__string(	dev_name,		skb->dev->name	)
		__field(	unsigned int,		napi_id		)
		__field(	u16,			queue_mapping	)
		__field(	const void *,		skbaddr		)
		__field(	u16,			protocol	)
		__field(	u8,			ip_summed	)
		__field(	unsigned int,		len		)
		__field(	unsigned int,		data_len	)
		__field(	unsigned int,		truesize	)
		__field(	bool,			mac_header_valid)
		__field(	int,			mac_header	)
		__field(	unsigned char,		nr_frags	)
		__field(	unsigned int,		csum		)
		__field(	u8 *,			pkt_start	)
		__field(	efct_qword_t *,		meta_addr	)
	),

	TP_fast_assign(
		__assign_str(dev_name, skb->dev->name);
#ifdef CONFIG_NET_LL_RX_POLL
		__entry->napi_id = skb->napi_id;
#else
		__entry->napi_id = 0;
#endif
		__entry->queue_mapping = rxq->index;
		__entry->skbaddr = skb;
		__entry->protocol = ntohs(skb->protocol);
		__entry->ip_summed = skb->ip_summed;
		__entry->len = skb->len;
		__entry->data_len = skb->data_len;
		__entry->truesize = skb->truesize;
		__entry->mac_header_valid = skb_mac_header_was_set(skb);
		__entry->mac_header = skb_mac_header(skb) - skb->data;
		__entry->nr_frags = skb_shinfo(skb)->nr_frags;
		__entry->csum = skb->csum;
		__entry->pkt_start = pkt_start;
		__entry->meta_addr = p_meta;
	),

	TP_printk("dev_name=%s napi_id=%#x queue_mapping=%u skbaddr=%p protocol=0x%04x ip_summed=%d len=%u data_len=%u truesize=%u mac_header_valid=%d mac_header=%d nr_frags=%d csum=%d pkt_start=%p meta_addr=%p ",
		  __get_str(dev_name), __entry->napi_id, __entry->queue_mapping,
		  __entry->skbaddr,__entry->protocol, __entry->ip_summed,
		  __entry->len, __entry->data_len, __entry->truesize,
		  __entry->mac_header_valid, __entry->mac_header, __entry->nr_frags,
		  __entry->csum, __entry->pkt_start, __entry->meta_addr)
);

TRACE_EVENT(xilinx_efct_transmit,

	TP_PROTO(const struct sk_buff *skb, const struct net_device *net_dev, struct efct_tx_queue *txq, u64 header),

	TP_ARGS(skb, net_dev, txq, header),

	TP_STRUCT__entry(
		__string(	dev_name,		net_dev->name	)
		__field(	const void *,		skbaddr		)
		__field(	u16,			protocol	)
		__field(	u8,			nr_frags	)
		__field(	unsigned int,		len		)
		__field(	unsigned int,		data_len	)
		__field(	int,			network_offset	)
		__field(	bool,			transport_offset_valid)
		__field(	int,			transport_offset)
		__field(	u8,			tx_flags	)
		__field(	u64,			pkt_header	)
		__field(	unsigned int,		piobuf_offset	)
		__field(	u8,			added_sequence	)
		__field(	u8,			completed_sequence )
		__field(	int,			inuse_fifo_bytes )
		__field(	int,			inflight_pkts	)
	),

	TP_fast_assign(
		__assign_str(dev_name, net_dev->name);
		__entry->skbaddr = skb;
		__entry->protocol = ntohs(skb->protocol);
		__entry->nr_frags = skb_shinfo(skb)->nr_frags;
		__entry->len = skb->len;
		__entry->data_len = skb->data_len;
		__entry->network_offset = skb_network_offset(skb);
		__entry->transport_offset_valid =
			skb_transport_header_was_set(skb);
		__entry->transport_offset = skb_transport_offset(skb);
		__entry->tx_flags = skb_shinfo(skb)->tx_flags;
		__entry->pkt_header = header;
		__entry->piobuf_offset = txq->piobuf_offset;
		__entry->added_sequence = txq->added_sequence;
		__entry->completed_sequence = txq->completed_sequence;
		__entry->inuse_fifo_bytes = txq->inuse_fifo_bytes.counter;
		__entry->inflight_pkts = txq->inflight_pkts.counter;
	),

	TP_printk("dev_name=%s skbaddr=%p protocol=0x%04x nr_frags=0x%d len=%u data_len=%u network_offset=%d transport_offset_valid=%d transport_offset=%d tx_flags=%d pkt_header=%lld piobuf_offset=%d added_sequence=%d completed_sequence=%d inuse_fifo_bytes=%d inflight_pkts=%d ",
		  __get_str(dev_name), __entry->skbaddr, __entry->protocol,
		  __entry->nr_frags, __entry->len, __entry->data_len,
		  __entry->network_offset, __entry->transport_offset_valid,
		  __entry->transport_offset, __entry->tx_flags, __entry->pkt_header,
		  __entry->piobuf_offset, __entry->added_sequence, __entry->completed_sequence,
		  __entry->inuse_fifo_bytes, __entry->inflight_pkts)
);

TRACE_EVENT(xilinx_efct_buff_push,

	TP_PROTO(struct efct_rx_queue *rxq, struct efct_nic_buffer_list *nbl, int id, bool is_dbl, bool rollover),

	TP_ARGS(rxq, nbl, id, is_dbl, rollover),

	TP_STRUCT__entry(
		__field(	unsigned int,		index		)
		__field(	unsigned int,		active_nic_buffs)
		__field(	unsigned char,		head_index	)
		__field(	unsigned char,		tail_index	)
		__field(	unsigned int,		seq_no		)
		__field(	int,			id		)
		__field(	bool,			is_dbl		)
		__field(	bool,			rollover	)
	),

	TP_fast_assign(
		__entry->index = rxq->index;
		__entry->active_nic_buffs = nbl->active_nic_buffs;
		__entry->head_index = nbl->head_index;
		__entry->tail_index = nbl->tail_index;
		__entry->seq_no = nbl->seq_no;
		__entry->id = id;
		__entry->is_dbl = is_dbl;
		__entry->rollover = rollover;
	),

	TP_printk("rxq=%d active_nic_buffs=%d head_index=%d tail_index=%d seq_no=%d id=%d is_dbl=%d rollover=%d ",
		  __entry->index, __entry->active_nic_buffs, __entry->head_index,
		  __entry->tail_index, __entry->seq_no, __entry->id,
		  __entry->is_dbl, __entry->rollover)
);

TRACE_EVENT(xilinx_efct_buff_pop,

	TP_PROTO(struct efct_rx_queue *rxq, struct efct_nic_buffer_list *nbl, int id, bool is_dbl, bool rollover),

	TP_ARGS(rxq, nbl, id, is_dbl, rollover),

	TP_STRUCT__entry(
		__field(	unsigned int,		index		)
		__field(	unsigned int,		active_nic_buffs)
		__field(	unsigned char,		head_index	)
		__field(	unsigned char,		tail_index	)
		__field(	unsigned int,		seq_no		)
		__field(	int,			id		)
		__field(	bool,			is_dbl		)
		__field(	bool,			rollover	)
	),

	TP_fast_assign(
		__entry->index = rxq->index;
		__entry->active_nic_buffs = nbl->active_nic_buffs;
		__entry->head_index = nbl->head_index;
		__entry->tail_index = nbl->tail_index;
		__entry->seq_no = nbl->seq_no;
		__entry->id = id;
		__entry->is_dbl = is_dbl;
		__entry->rollover = rollover;
	),

	TP_printk("rxq=%d active_nic_buffs=%d head_index=%d tail_index=%d seq_no=%d id=%d is_dbl=%d rollover=%d ",
		  __entry->index, __entry->active_nic_buffs, __entry->head_index,
		  __entry->tail_index, __entry->seq_no, __entry->id,
		  __entry->is_dbl, __entry->rollover)
);
#endif /* TRACE_EVENTS_XILINX_EFCT_H */

#include <trace/define_trace.h>
