#!/bin/bash

p=$(basename "$0")
bin=$(dirname "$0")

err  () { echo 1>&2 "$*";   }
log  () { err "$p: $*";     }
fail () { log "$*"; exit 1; }
try  () { "$@" || fail "ERROR: '$*' failed"; }

DIR=$(dirname "$0")
N_MODS="xilinx_efct"

usage () {
  err
  err "usage:  $p [options] [net]"
  err
  err "options:"
  err "  --debug       - verbose logging of commands"
  err
  exit 1
}

down () {
  ethif=$1

  if /sbin/ip link show dev "$ethif" >/dev/null 2>&1; then
    /sbin/ip link set dev "$ethif" down
  else
    log "$ethif is not configured."
  fi
}

list_net_dev () {
  for dir in /sys/class/net/*; do
    if [ -L "$dir/device/driver" ]; then
      driver="$(basename "$(readlink "$dir/device/driver")")"
    elif [ -L "$dir/driver" ]; then
      driver="$(basename "$(readlink "$dir/driver")")"
    else
      continue
    fi
    if echo "$driver" | grep -q -x "${N_MODS/ /\|}"; then
      basename "$dir"
    fi
  done
}

donet () {
  for ethif in $(list_net_dev); do
    down $ethif
    [ ! -f /sys/class/net/$ethif/device/driver/unbind ] ||
      echo -n "$pci_dev" > /sys/class/net/$ethif/device/driver/unbind
  done

  for m in $N_MODS; do
    grep -q "^$m " /proc/modules && {
     echo "Removing $m driver"
      /sbin/rmmod "$m" || { log "rmmod $m failed (rc $?)"; bad=true; }
    }
  done
}

###############################################################################
# main

[ `whoami` == "root" ] || fail "Please run as root"

bad=false

while [ $# -gt 0 ]; do
  case "$1" in
    --debug)    set -x;;
    -*)         usage;;
    *)          break;;
  esac
  shift
done

# Doit!
donet

$bad && fail "Not all modules unloaded"
exit 0

