/* SPDX-License-Identifier: BSD-2-Clause */
/* (c) Copyright 2010-2011 Xilinx, Inc. */

#ifndef _UTIL_REQ_H
#define _UTIL_REQ_H
#include <asm/types.h>

static inline int
efct_sock_ioctl(const char *ifname, __u16 cmd, union efct_ioctl_data *u)
{
	struct efct_sock_ioctl req;
	struct ifreq ifr;
	int sock;
	int rc = 0;

	sock = socket(PF_INET, SOCK_DGRAM, IPPROTO_IP);
	if (sock < 0) {
		fprintf(stderr, "Could not open socket: %m\n");
		exit(1);
	}

	memset(&ifr, 0, sizeof(ifr));
	strncpy(ifr.ifr_name, ifname, sizeof(ifr.ifr_name));
	ifr.ifr_data = (caddr_t)&req;
	memset(&req, 0, sizeof(req));
	req.cmd = cmd;
	memcpy(&req.u, u, sizeof(*u));
	if (ioctl(sock, SIOCEFCT, &ifr) == -1)
		rc = -errno;
	close(sock);
	return rc;
}

#endif
