################################################################################
#
# Driver for Xilinx network controllers and boards
# Copyright 2021 Xilinx Inc.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation, incorporated herein by reference.
#
################################################################################

# We use dirname and basename a lot which can be slow on Cygwin,
# and they're simple enough to reimplement with built-ins.
dirname () {
    [ "${1%/*}" = "$1" ] && echo . || echo "${1%/*}"
}
basename () {
    local name="${1##*/}"
    echo "${name%$2}"
}

p=$(basename "$0")
me=$(basename "$0")
bin=$(cd "$(dirname "$0")" && /bin/pwd)
export PATH="$bin:$PATH"

err  () { echo -e 1>&2 "$*";   }
log  () { err "$p: $*";     }
fail () { log "$*"; exit 1; }
try  () { "$@" || fail "'$*' failed"; }
try_quiet  () { "$@" 2>&1 > /dev/null || fail "'$*' failed"; }
