################################################################################
#
# Driver for Xilinx network controllers and boards
# Copyright 2021 Xilinx Inc.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation, incorporated herein by reference.
#
################################################################################

%{!?dist: %{expand: %%define disttag %%(. %%{_topdir}/SOURCES/xilinx-efct-disttag; echo -n $(xilinx-efct_disttag))}}
%{!?kernel:  %{expand: %%define kernel %%(uname -r)}}
%{!?kpath: %{expand: %%define kpath /lib/modules/%%{kernel}/build}}

%{?xilinx-efct_minimal: %{expand: %%define xilinx-efct_config CONFIG_XILINX_DEBUGFS= }}

%define redhat     %(! [ "%{_vendor}" = "redhat" ] ; echo $?)

Name:           xilinx-efct
Version:        %{pkgversion}
Release:        1
Epoch:          0

Summary:        Xilinx X3 network adapter device driver

Group:          System Environment/Kernel
License:        GPLv2
URL:		http://www.xilinx.com/
Vendor:		Xilinx Inc

Source0:        %{name}-%{version}.tar.gz
Source1:        %{name}-disttag

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%if "%{dist}" == ".el7"
BuildRequires:  binutils, gcc, make, kernel-module-auxiliary-%{dist}-%{kernel}
%else
BuildRequires:  binutils, gcc, make
%endif
%description
The Linux kernel driver for Xilinx X3 Ethernet
controllers.

This builds a single RPM for a specific kernel version on any
supported Linux distribution.

%define binary_name kernel-module-%{name}-%{dist}-%{kernel}

%package -n %{binary_name}
Summary:        %{summary}
Group:          %{group}
Provides:       %{name}-kmod-symvers = %{kernel}

%description -n %{binary_name}
The Linux kernel driver for xilinx X3 Ethernet
controllers.

# Inhibit debuginfo package
%define debug_package %{nil}

# -----------------------------------------------------------------------------

%prep
%setup -q

# -----------------------------------------------------------------------------

%build

[ -d "%{kpath}" ] || {
  set +x
  echo >&2 "ERROR: Kernel headers not found.  They should be at:"
  echo >&2 "ERROR:   %{kpath}"
%if %{redhat}
  echo >&2 "Hint: Install the $(echo '%{kernel}' | sed -r 's/(.*)(smp|hugemem|largesmp|PAE|xen)$/kernel-\2-devel-\1/; t; s/^/kernel-devel-/') package"
%endif
  exit 1
}

cd $RPM_BUILD_DIR/%{name}-%{version}

# do the build
%{__make} -C linux_net -j4 KVER=%{kernel} KPATH="%{kpath}" modules

# -----------------------------------------------------------------------------

%install

cd "$RPM_BUILD_DIR/%{name}-%{version}"

# do the install
%{__make} -C linux_net INSTALL_MOD_PATH="${RPM_BUILD_ROOT}" INSTALL_MOD_DIR="updates" \
  KVER=%{kernel} KPATH="%{kpath}" modules_install
mkdir -p ${RPM_BUILD_ROOT}/lib/modules/%{kernel}/build/include/linux/net/xilinx
%{__install} -m 0644 linux_net/include/linux/net/xilinx/xlnx_efct.h \
  ${RPM_BUILD_ROOT}/lib/modules/%{kernel}/build/include/linux/net/xilinx/xlnx_efct.h

# rpm will complain about these files generated by depmod
rm -f ${RPM_BUILD_ROOT}/lib/modules/%{kernel}/modules.*

# -----------------------------------------------------------------------------

%clean
%{__rm} -rf $RPM_BUILD_ROOT

# -----------------------------------------------------------------------------

%post -n %{binary_name}
/sbin/depmod -a %{kernel}
if [ "$(uname -r)" = "%{kernel}" ]; then
    if [ -x /etc/hotplug/pci.rc ]; then
        /etc/hotplug/pci.rc start >/dev/null
    fi
    modprobe xilinx_efct
fi
udevadm control --reload
true

%postun -n %{binary_name}
/sbin/depmod -a %{kernel}
true

# -----------------------------------------------------------------------------

%files -n %{binary_name}
%defattr(-,root,root,-)

/lib/modules/%{kernel}/*/*
