#define  _GNU_SOURCE

/****************************************************************************
 * Driver for Xilinx network controllers and boards
 * Copyright 2021 Xilinx Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <dlfcn.h>
#include <sys/utsname.h>


#define ME		"libfakeos.so: "
#define TRACE(x)

static int (*sys_uname)(struct utsname*);


static int load_sym_fail(const char* sym)
{
  fprintf(stderr, ME "dlsym(\"%s\") failed\n", sym);
  fprintf(stderr, ME "dlerror '%s'\n", dlerror());
  return -1;
}


static void find_original_syms()
{
  *(void**)(void*)& sys_uname = dlsym(RTLD_NEXT, "uname");
  if( sys_uname == 0 )  load_sym_fail("uname");
  TRACE(fprintf(stderr, ME "uname = %p\n", sys_uname));
}


int uname(struct utsname* buf)
{
  int rc;

  if (sys_uname == NULL)
    find_original_syms();

  TRACE(fprintf(stderr, ME "uname()\n"));
  rc = sys_uname(buf);
  TRACE(fprintf(stderr, ME "uname: sysname=%s nodename=%s release=%s "
		"version=%s machine=%s\n", buf->sysname, buf->nodename,
		buf->release, buf->version, buf->machine));
  if( getenv("FAKEARCH_MACHINE") )
    strcpy(buf->machine, getenv("FAKEARCH_MACHINE"));
  if( getenv("FAKEARCH_RELEASE") )
    strcpy(buf->release, getenv("FAKEARCH_RELEASE"));
  return rc;
}

