// SPDX-License-Identifier: GPL-2.0 OR BSD-2-Clause
/*****************************************************************************
* Copyright (c) 2021 Xilinx, Inc. All rights reserved.
*
* This software is available to you under a choice of one of two
* licenses. You may choose to be licensed under the terms of the GNU
* General Public License (GPL) Version 2, available from the file
* LICENSE in the main directory of this source tree, or the
* BSD license below:
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1. Redistributions of source code must retain the above copyright
*    notice unmodified, this list of conditions, and the following
*    disclaimer.
* 2. Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
* SUCH DAMAGE.
*
* GPL license :
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation version 2.
*
*/
#include <linux/ioctl.h>
#include <linux/types.h>

#define AUXTEST_IOC_MAGIC  0xef

#define AUXTEST_ADD_EVQ			_IOW(AUXTEST_IOC_MAGIC, 0, int)
#define AUXTEST_FREE_EVQ		_IOW(AUXTEST_IOC_MAGIC, 1, int)
#define AUXTEST_BIND_RXQ		_IOW(AUXTEST_IOC_MAGIC, 2, int)
#define AUXTEST_FREE_RXQ		_IOW(AUXTEST_IOC_MAGIC, 3, int)
#define AUXTEST_ALLOC_TXQ		_IOW(AUXTEST_IOC_MAGIC, 4, int)
#define AUXTEST_FREE_TXQ		_IOW(AUXTEST_IOC_MAGIC, 5, int)
#define AUXTEST_ROLLOVER_RXQ		_IOW(AUXTEST_IOC_MAGIC, 6, int)
#define AUXTEST_GET_HUGEPAGES		_IOW(AUXTEST_IOC_MAGIC, 7, int)
#define AUXTEST_FILTER_INSERT		_IOW(AUXTEST_IOC_MAGIC, 8, int)
#define AUXTEST_FILTER_REMOVE		_IOW(AUXTEST_IOC_MAGIC, 9, int)

struct user_filter_params {
        unsigned dst_ip;
        unsigned pdst;
        unsigned flags;
        unsigned mask;
        unsigned long long qid;
        unsigned flow_type;
        unsigned mcast;

};
